<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Farmer extends Model 
{

    protected $table = 'farmers';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function group()
    {
        return $this->hasOne('FarmerGroup');
    }

    public function location()
    {
        return $this->hasOne('Location');
    }

    public function farms()
    {
        return $this->hasMany('Farm');
    }

    public function farmingEquipments()
    {
        return $this->hasMany('FarmingEquipment');
    }

    public function leaders()
    {
        return $this->hasMany('\GroupLeader');
    }

}